/* AUTOGENERATED FILE. DO NOT EDIT. */

//=======Test Runner Used To Run Each Test Below=====
#define RUN_TEST(TestFunc, TestLineNum) \
{ \
  Unity.CurrentTestName = #TestFunc; \
  Unity.CurrentTestLineNumber = TestLineNum; \
  Unity.NumberOfTests++; \
  if (TEST_PROTECT()) \
  { \
      setUp(); \
      TestFunc(); \
  } \
  if (TEST_PROTECT() && !TEST_IS_IGNORED) \
  { \
    tearDown(); \
  } \
  UnityConcludeTest(); \
}

//=======Automagically Detected Files To Include=====
#include "unity.h"
#include <setjmp.h>
#include <stdio.h>
#include "config.h"
#include "ntp.h"
#include "ntp_stdlib.h"
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

//=======External Functions This Runner Calls=====
extern void setUp(void);
extern void tearDown(void);
extern void test_Digest_AES128CMAC(void);
extern void test_Digest_MD4(void);
extern void test_Digest_MD5(void);
extern void test_Digest_MDC2(void);
extern void test_Digest_RIPEMD160(void);
extern void test_Digest_SHA1(void);
extern void test_Digest_SHA512(void);
extern void test_Digest_DSA(void);
extern void test_Digest_DSA_SHA(void);
extern void test_Digest_3DES(void);
extern void test_Digest_SHA256(void);
extern void test_Digest_SHA3_256(void);
extern void test_Some_Digests_Succeeded(void);


//=======Suite Setup=====
static void suite_setup(void)
{
extern int change_iobufs(int);
extern int change_logfile(const char*, int);
change_iobufs(1);
change_logfile("stderr", 0);
}

//=======Test Reset Option=====
void resetTest(void);
void resetTest(void)
{
  tearDown();
  setUp();
}

char const *progname;


//=======MAIN=====
int main(int argc, char *argv[])
{
  progname = argv[0];
  suite_setup();
  UnityBegin("digests.c");
  RUN_TEST(test_Digest_AES128CMAC, 165);
  RUN_TEST(test_Digest_MD4, 200);
  RUN_TEST(test_Digest_MD5, 235);
  RUN_TEST(test_Digest_MDC2, 266);
  RUN_TEST(test_Digest_RIPEMD160, 301);
  RUN_TEST(test_Digest_SHA1, 338);
  RUN_TEST(test_Digest_SHA512, 375);
  RUN_TEST(test_Digest_DSA, 412);
  RUN_TEST(test_Digest_DSA_SHA, 449);
  RUN_TEST(test_Digest_3DES, 486);
  RUN_TEST(test_Digest_SHA256, 523);
  RUN_TEST(test_Digest_SHA3_256, 560);
  RUN_TEST(test_Some_Digests_Succeeded, 590);

  return (UnityEnd());
}
